#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA口配置输出
	TRISB = 0X00;   //PB口配置输出
	
	PORTA = 0X00;	  //PORTA输出低
	PORTB = 0X00;	  //PORTB输出低
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关闭PA开漏
	PBOD = 0X00;    //关闭PB开漏
	
	ANASEL0 = 0X00; //关闭PA模拟通道
	ANASEL1 = 0X00; //关闭PB模拟通道
}



unsigned short ADC_SampleFilter(void)
{
   unsigned char  j;
   unsigned short Volt       = 0;
   unsigned char  Time_Out   = 0;
 
   for(j = 0;j<=5;j++)
   {
          GO = 1;                         //A/D转换状态位
          Time_Out = 100;                 //设置超时时间
          while(GO)                       //A/D转换正在进行
          {
                 Time_Out--;              //等待超时
                 if(Time_Out == 0)        //防止程序跑到这里死掉了
                 {
                     ADON = 0;         //除能A/D转换器模块
                     GO = 0;           //清除转换标志
                     ADON = 1;         //使能能A/D转换器模块
                     GO = 1;           //清除转换标志
                     break;
                 }
          }
   }
   
   Volt = (ADRESH<<8)|ADRESL;//读取ADC采集值
 
   return Volt;
}
/*

*/
void ADC_Config(void)
{
	TRISA5 = 1;PA5PD = 1;PA5PU = 1;PA5OD = 0;PA5AEN = 1;
	ADCON0 = 0X09;  //配置PA5为ADC采集通道，使能A/D模拟使能位;
	ADCON1 = 0X7E;  //参考电压选择FVR，A/D转换时钟选择FOSC/64(ADSP=1)
 

       GIEH   = 1; 
       GIEL   = 1;
       IPEN   = 1;
       ADIP = 1;//ADC的高优先级使能
       ADIE = 1;//ADC的中断使能位
       ADIF = 0;//初始化ADC的中断标志位

}

void fvr_int(void)
{
	FVRCON0 = 0X31;//使能FVR，2倍放大，选择VREF1P0(1.0V)通道
}
